-- Tree.lua
-- Copyright (c) 2001 Marcio M. Andrade

-- Draws a recursive tree.
-- Try different sizes, angles and shrink factors to draw different trees.

size = 50
angle = 20
shrink = 0.65   -- must be less than 1

w,h,depth,hasColor = pmode()

function tree(d)
  if d >= 2 then
    if hasColor == 1 then
      pcolor(prgb(0,255-4*d,0))
    end
    pwalk(d)
    local x,y = ppos()
    pturn(-angle)
    tree(shrink*d)
    pmoveto(x,y)
    pturn(2*angle)
    tree(shrink*d)
    pturn(-angle)
  end
end

w,h = pmode()
pmoveto(w/2,h-1)

pheading(90)
tree(size)
pevent()
